targetlist = {
	["blue"] = {
		["AFAC Beirout North"] = {
			task = "AFAC",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "AFAC Beirout North",
			axis = 105, --in degrees
			radius = 50000,
			text = "North of Beirut",
			inactive = true,
		},
		["AFAC Beirout South"] = {
			task = "AFAC",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "AFAC Beirout South",
			axis = 90, --in degrees
			radius = 50000,
			text = "South of Beirut",
			inactive = true,
		},
		["AFAC Beirout East"] = {
			task = "AFAC",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "AFAC Beirout East",
			axis = 30, --in degrees
			radius = 50000,
			text = "East of Beirut",
			inactive = true,
		},
		["Russian-Expeditionary-Force-Arty-1"] = {
			task = "Strike",
			priority = 30,
			additionalGroupName = {"Russian-Expeditionary-Force-Arty-AA"},
			picture = {"Russian-Expeditionary-Force-Arty-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Russian-Expeditionary-Force-Arty-1",
			inactive = true,
		},
		["Russian Expeditionary Force 1"] = {
			task = "Strike",
			priority = 30,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "Russian Expeditionary Force 1",
			inactive = true,
		},
		["SAM-SA10-Russian"] = {
			task = "Strike",
			priority = 35,
			additionalGroupName = {"SAM-SA10-Russian-AA"},
			picture = {"SAM-SA10-Russian.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA10-Russian",
			inactive = true,
		},
		["Insurgent-Mortar-Team-1"] = {  --------145° for 2 or 3 NM
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Insurgent-Mortar-Team-1",
			text = "At least one mortar is pounding Beirut airport. Its position is estimated to the 145° and 2 or 3NM from the main airport terminal",
			inactive = true,
		},
		["Insurgent-Mortar-Team-2"] = {
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Insurgent-Mortar-Team-2",
			text = "At least one mortar is pounding Beirut airport. Its position is estimated to the 65° and  1 or 2NM from the main airport terminal",
			inactive = true,
		},
		["Insurgent-Mortar-Team-3"] = {
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Insurgent-Mortar-Team-3",
			text = "At least one mortar is pounding Beirut airport. Its position is estimated to the 195° and  2 or 3NM from the main airport terminal",
			inactive = true,
		},
		["Syrian-11th-Armored-Div-64th-Brig-Artillery"] = {
			task = "Strike",
			zone = "A",
			priority = 22,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Syrian-11th-Armored-Div-64th-Brig-Artillery",
			inactive = true,
		},
		["Syrian-11th-Armored-Div-64th-Brig-HQ"] = {
			task = "Strike",
			zone = "A",
			priority = 11,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-HQ-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-HQ-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-64th-Brig-Cie-1"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-Cie-1-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-1-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-64th-Brig-Cie-2"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-Cie-2-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-2-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-64th-Brig-Cie-3"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-Cie-3-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-3-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-64th-Brig-Cie-4"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-Cie-4-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-64th-Brig-Cie-4-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-66th-Brig-HQ"] = {
			task = "Strike",
			zone = "A",
			priority = 11,
			additionalGroupName = {"Syrian-11th-Armored-Div-64th-Brig-HQ-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-HQ-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-66th-Brig-Cie-1"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-66th-Brig-Cie-1-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-1-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-66th-Brig-Cie-2"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-66th-Brig-Cie-2-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-2-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-66th-Brig-Cie-3"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-66th-Brig-Cie-2-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-3-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-66th-Brig-Cie-4"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-66th-Brig-Cie-4-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-66th-Brig-Cie-4-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-45th-Brig-HQ"] = {
			task = "Strike",
			zone = "A",
			priority = 11,
			additionalGroupName = {"Syrian-11th-Armored-Div-45th-Brig-HQ-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-HQ-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-45th-Brig-Cie-1"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-45th-Brig-Cie-1-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-1-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-45th-Brig-Cie-2"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-45th-Brig-Cie-2-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-2-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-45th-Brig-Cie-3"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-45th-Brig-Cie-3-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-3-8",
				},
			},
		},
		["Syrian-11th-Armored-Div-45th-Brig-Cie-4"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-11th-Armored-Div-45th-Brig-Cie-4-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-1",
				},
				[2] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-2",
				},
				[3] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-3",
				},
				[4] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-4",
				},
				[5] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-5",
				},
				[6] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-6",
				},
				[7] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-7",
				},
				[8] = {
					name = "Syrian-11th-Armored-Div-45th-Brig-Cie-4-8",
				},
			},
		},
		["Syrian-3rd-Armored-Div-25th-Brig-Artillery"] = {
			task = "Strike",
			zone = "A",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Syrian-3rd-Armored-Div-25th-Brig-Artillery",
			inactive = true,
		},
		["Syrian-3rd-Armored-Div-25th-Brig-HQ"] = {
			task = "Strike",
			zone = "A",
			priority = 11,
			additionalGroupName = {"Syrian-3rd-Armored-Div-25th-Brig-HQ-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-1",
				},
				[2] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-2",
				},
				[3] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-3",
				},
				[4] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-4",
				},
				[5] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-5",
				},
				[6] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-6",
				},
				[7] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-7",
				},
				[8] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-HQ-8",
				},
			},
		},
		["Syrian-3rd-Armored-Div-25th-Brig-Cie-1"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-3rd-Armored-Div-25th-Brig-Cie-1-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-1",
				},
				[2] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-2",
				},
				[3] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-3",
				},
				[4] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-4",
				},
				[5] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-5",
				},
				[6] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-6",
				},
				[7] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-7",
				},
				[8] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-1-8",
				},
			},
		},
		["Syrian-3rd-Armored-Div-25th-Brig-Cie-2"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-3rd-Armored-Div-25th-Brig-Cie-2-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-1",
				},
				[2] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-2",
				},
				[3] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-3",
				},
				[4] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-4",
				},
				[5] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-5",
				},
				[6] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-6",
				},
				[7] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-7",
				},
				[8] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-2-8",
				},
			},
		},
		["Syrian-3rd-Armored-Div-25th-Brig-Cie-3"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-3rd-Armored-Div-25th-Brig-Cie-3-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-1",
				},
				[2] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-2",
				},
				[3] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-3",
				},
				[4] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-4",
				},
				[5] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-5",
				},
				[6] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-6",
				},
				[7] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-7",
				},
				[8] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-3-8",
				},
			},
		},
		["Syrian-3rd-Armored-Div-25th-Brig-Cie-4"] = {
			task = "Strike",
			zone = "A",
			priority = 8,
			additionalGroupName = {"Syrian-3rd-Armored-Div-25th-Brig-Cie-4-AA"},
			picture = {"Frontlines.png"},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-1",
				},
				[2] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-2",
				},
				[3] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-3",
				},
				[4] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-4",
				},
				[5] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-5",
				},
				[6] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-6",
				},
				[7] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-7",
				},
				[8] = {
					name = "Syrian-3rd-Armored-Div-25th-Brig-Cie-4-8",
				},
			},
		},
		["Beirut SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Beirut-Rafic Hariri",
			radius = 50000,
			inactive = false,
		},
		["Akrotiri Airbase SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Akrotiri",
			radius = 300000,
			inactive = false,
		},
		["Larnaca Airbase SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Larnaca",
			radius = 300000,
			inactive = false,
		},
		["Incirlik Airbase SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Incirlik",
			radius = 300000,
			inactive = false,
		},
		["Hatay Airbase SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Hatay",
			radius = 300000,
			inactive = false,
		},
		["Incirlik Airbase Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Incirlik",
			radius = 100000,
			inactive = false,
		},
		["Larnaca Airbase Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Larnaca",
			radius = 110000,
			inactive = false,
		},
		["Akrotiri Airbase Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Akrotiri",
			radius = 180000,
			inactive = false,
		},
		["Paphos Airbase Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Paphos",
			radius = 200000,
			inactive = true,
		},
		["CVN-71 Theodore Roosevelt Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "CVN-71 Theodore Roosevelt",
			radius = 100000,
			inactive = false,
		},
		["CVN-71 Theodore Roosevelt CAP"] = {
			task = "CAP",
			priority = 20,
			attributes = {"CV CAP"},
			firepower = {
				min = 2,
				max = 2,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 90, 80000},
			radius = 111000,
			text = "",
			inactive = false,
		},
		["Roosevelt SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 3,
			},
			base = "CVN-71 Theodore Roosevelt",
			radius = 300000,
			inactive = false,
		},
		["Tarawa SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
			},
			base = "LHA_Tarawa",
			radius = 300000,
			inactive = false,
		},
		-- ["Nassau SAR Alert"] = {
			-- task = "SAR",
			-- priority = 100,
			-- attributes = {},
			-- firepower = {
				-- min = 1,
				-- max = 2,
			-- },
			-- base = "LHA_Nassau",
			-- radius = 300000,
			-- inactive = false,
		-- },
		["CVN-71 Theodore Roosevelt AEW"] = {
			task = "AWACS",
			priority = 20,
			attributes = {"AEW"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt",90, 20000},
			text = "",
			inactive = false,
		},
		["Mission Support Tanker CVN-71 Theodore Roosevelt"] = {
			task = "Refueling",
			priority = 10,
			attributes = {"medium"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 100, 55000},
			text = "",
			inactive = true,
		},
		["Recovery Tanker CVN-71 Theodore Roosevelt"] = {
			task = "Refueling",
			priority = 5,
			attributes = {"low"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 95, 30000},
			text = "",
			inactive = true,
		},	
		["AWACS"] = {
			task = "AWACS",
			priority = 20,
			attributes = {"Sentry"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "AWACS",
			axis = 225, --in degrees
			radius = 15000,
			text = "",
		},
		-- ["AEW"] = {
			-- task = "AWACS",
			-- priority = 20,
			-- attributes = {"AEW"},
			-- firepower = {
				-- min = 1,
				-- max = 1,
			-- },
			-- refpoint = "AEW",
			-- radius = 15000,
			-- text = "",
			-- inactive = true,
		-- },
		["Tanker Track Incirlik"] = {
			task = "Refueling",
			priority = 20,
			attributes = {"KC135MPRS"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker Track Incirlik",
			axis = 215, --in degrees
			radius = 15000,
			alt = 6096, --in meters
			text = "Low level",
			inactive = false,
		},
		["Tanker Track Akrotiri"] = {
			task = "Refueling",
			priority = 20,
			attributes = {"KC135MPRS"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker Track Akrotiri",
			axis = 215, --in degrees
			radius = 15000,
			alt = 6705, --in meters
			text = "Medium level",
			inactive = false,
		},
		["Tanker Track Incirlik USAF"] = {
			task = "Refueling",
			priority = 20,
			attributes = {"KC135"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker Track Incirlik KC135",
			axis = 215, --in degrees
			radius = 15000,
			alt = 7315, --in meters
			text = "High level",
			inactive = false,
		},
		["Sweep Rene-Mouawad"] = {
			task = "Fighter Sweep",
			priority = 5,
			attributes = {},
			firepower = {
				min = 4,
				max = 4,
			},
			x = -42402,
			y = -34449,
			text = "just west of Rene-Mouawad Airbase",
			inactive = true,
		},
		["Sweep Beirut"] = {
			task = "Fighter Sweep",
			priority = 5,
			attributes = {},
			firepower = {
				min = 4,
				max = 4,
			},
			x = -128292,
			y = -41533,
			text = "above Beirut city ",
			inactive = false,
		},
		["Sweep Bassel-Al-Assad"] = {
			task = "Fighter Sweep",
			priority = 5,
			attributes = {},
			firepower = {
				min = 4,
				max = 4,
			},
			x = 37733,
			y = -36220,
			text = "just west of Bassel-Al-Assad Airbase",
			inactive = true,
		},
		["EWR-Rene-Mouawad Site"] = {
			task = "Strike",
			priority = 12,
			picture = {"EWR-Rene-Mouawad Site.png", "Syria-North.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-Rene-Mouawad",
		},
		["EWR-Rayak Site"] = {
			task = "Strike",
			priority = 12,
			picture = {"EWR-Rayak Site.png", "Syria-South.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-Rayak",
		},
		["EWR-Mezzeh Site"] = {
			task = "Strike",
			priority = 10,
			picture = {"EWR-Mezzeh Site.png", "Syria-South.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-Mezzeh",
		},
		["Antiship battery 1"] = {
			task = "Strike",
			priority = 30,
			additionalGroupName = {"Antiship battery 1-AA"},
			picture = {"Antiship battery 1.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Antiship battery 1",
		},
		["SAM-SA2-Frontline-North"] = {
			task = "Strike",
			priority = 25,
			picture = {"SAM-SA2-Frontline-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA2-Frontline-North",
			inactive = true,
		},
		["SAM-SA6-Tripoli"] = {
			task = "Strike",
			priority = 25,
			picture = {"SAM-SA6-Tripoli.png", "Syria-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA6-Tripoli",
		},
		["SAM-SA6-Beirut-North"] = {
			task = "Strike",
			priority = 25,
			picture = {"SAM-SA6-Beirut-North.png", "Syria-South.png", "Syria-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA6-Beirut-North",
		},
		["SAM-SA6-Beirut-South"] = {
			task = "Strike",
			priority = 25,
			picture = {"SAM-SA6-Beirut-South.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA6-Beirut-South",
		},
		["SAM-SA6-Saida"] = {
			task = "Strike",
			priority = 25,
			picture = {"SAM-SA6-Saida.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA6-Saida",
		},
		["SAM-SA5-Tabqa"] = {
			task = "Strike",
			priority = 4,
			picture = {"Syria-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA5-Tabqa",
		},
		["SAM-SA5-Baniyas"] = {
			task = "Strike",
			priority = 5,
			picture = {"SAM-SA5-Baniyas.png", "Syria-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA5-Baniyas",
		},
		["SAM-SA5-Al-Qusayr"] = {
			task = "Strike",
			priority = 6,
			picture = {"SAM-SA5-Al-Qusayr.png", "Syria-North.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA5-Al-Qusayr",
		},
		["SAM-SA6-An-Nasiriyah"] = {
			task = "Strike",
			priority = 6,
			picture = {"SAM-SA6-An-Nasiriyah.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "SAM-SA6-An-Nasiriyah",
		},
		["SAM-SA6-Rayak-South"] = {
			task = "Strike",
			priority = 8,
			picture = {"SAM-SA6-Rayak-South.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "SAM-SA6-Rayak-South",
		},
		["SAM-SA2-Mezzeh-South"] = {
			task = "Strike",
			priority = 8,
			picture = {"SAM-SA2-Mezzeh-South.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA2-Mezzeh-South",
		},
		["SAM-SA2-Al-Dumayr-West"] = {
			task = "Strike",
			priority = 8,
			picture = {"SAM-SA2-Al-Dumayr-West.png", "Syria-South.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA2-Al-Dumayr-West",
		},
		["SAM-SA5-At-Tanf"] = {
			task = "Strike",
			priority = 5,
			picture = {"Syria-South.png", "Syria-East.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SAM-SA5-At-Tanf",
		},
		["CAP Incirlik"] = {
			task = "CAP",
			priority = 20,
			attributes = {"Air Forces"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP Incirlik",
			axis = 45, --in degrees
			radius = 50000,
			text = "South East of Incirlik",
		},
		["CAP North Cyprus"] = {
			task = "CAP",
			priority = 20,
			attributes = {"Air Forces"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP North Cyprus",
			axis = 185, --in degrees
			radius = 50000,
			text = "North East of Larnaca",
		},
		["CAP Center Cyprus"] = {
			task = "CAP",
			priority = 20,
			attributes = {"Air Forces"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP Center Cyprus",
			axis = 185, --in degrees
			radius = 50000,
			text = "East of Larnaca",
		},
		["CAP Libanon"] = {
			task = "CAP",
			priority = 20,
			attributes = {"Air Forces"},
			firepower = {
				min = 2,
				max = 2,
			},
			refpoint = "CAP Libanon",
			axis = 185, --in degrees
			radius = 50000,
			text = "West of Beirut",
		},
		["Airlift Beirut-Rafic Hariri Airbase"] = {
			task = "Transport",
			priority = 50,
			attributes = {},
			firepower = {
				min = 1,
				max = 3,
			},
			base = "Larnaca",
			destination = "Beirut-Rafic Hariri",
			inactive = true,
		},
		["Rayak Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 7,
			picture = {"Rayak Airbase.png", "Rayak Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "Rayak",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Rayak Airbase Command Center",
					x = -129593.171875,
					y = 5258.416015625,
				},
				[2] = {
					name = "Rayak Airbase Command Center-2",
					x = -129628.0078125,
					y = 5172.5810546875,
				},
				[3] = {
					name = "Rayak Airbase Ammo Supply 1",
					x = -129426.453125,
					y = 5512.615234375,
				},
				[4] = {
					name = "Rayak Airbase Ammo Supply 2",
					x = -129572.8515625,
					y = 5430.8803710938,
				},
				[5] = {
					name = "Rayak Airbase Ammo Supply 3",
					x = -129649.2734375,
					y = 5429.2392578125,
				},
				[6] = {
					name = "Rayak Airbase Fuel Supply",
					x = -130069.6796875,
					y = 4628.3110351562,
				},
			},
		},
		["Rayak Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 8,
            picture = {"Rayak Airbase.png", "Rayak Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "Rayak",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Aleppo Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 6,
			picture = {"Aleppo Airbase.png", "Aleppo Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Aleppo",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Aleppo Airbase Control Tower",
					x = 00126006,
					y = 00123359,
				},
				[2] = {
					name = "Aleppo Airbase Command Center-1",
					x = 00126070,
					y = 00123307,
				},
				[3] = {
					name = "Aleppo Airbase Command Center-2",
					x = 00126035,
					y = 00123477,
				},
				[4] = {
					name = "Aleppo Airbase Command Center-3",
					x = 00126006,
					y = 00123297,
				},
				[5] = {
					name = "Aleppo Airbase Command Center-4",
					x = 00125999,
					y = 00123475,
				},
				[6] = {
					name = "Aleppo Airbase Ammo Supply",
					x = 00126138,
					y = 00122248,
				},
				[7] = {
					name = "Aleppo Airbase Fuel Tank-1",
					x = 00126039,
					y = 00123535,
				},
				[8] = {
					name = "Aleppo Airbase Fuel Tank-2",
					x = 00126036,
					y = 00123555,
				},
				[9] = {
					name = "Aleppo Airbase Fuel Tank-3",
					x = 00126032,
					y = 00123574,
				},
			},
		},
		["Aleppo Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 7,
            picture = {"Aleppo Airbase.png", "Aleppo Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Aleppo",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Mezzeh Airbase"] = {
			inactive = true,
			task = "Strike",
			priority = 7,
			picture = {"Mezzeh Airbase.png", "Mezzeh Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "Mezzeh",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Mezzeh Airbase Command Center",
					x = -171439.17822266,
					y = 24974.324615479,
				},
				[2] = {
					name = "Mezzeh Airbase Command Center-2",
					x = -171464.01220703,
					y = 24783.419067383,
				},
				[3] = {
					name = "Mezzeh Airbase Ammo Supply 1",
					x = -171733.953125,
					y = 26001.853515625,
				},
				[4] = {
					name = "Mezzeh Airbase Fuel Tank 1",
					x = -171496.21875,
					y = 24630.65625,
				},
				[5] = {
					name = "Mezzeh Airbase Fuel Tank 2",
					x = -171504.46875,
					y = 24617.826171875,
				},
				[6] = {
					name = "Mezzeh Airbase Fuel Tank 3",
					x = -171512.734375,
					y = 24604.6796875,
				},
				[7] = {
					name = "Mezzeh Airbase Fuel Tank 4",
					x = -171520.15625,
					y = 24591.796875,
				},
				[8] = {
					name = "Mezzeh Airbase Fuel Tank 5",
					x = -171527.90625,
					y = 24578.5,
				},
			},
		},
		["Mezzeh Airbase Runway"] = {
            inactive = true,
			task = "Runway Attack",
            priority = 8,
            picture = {"Mezzeh Airbase.png", "Mezzeh Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "Mezzeh",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["An Nasiriyah Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 6,
			picture = {"An Nasiriyah Airbase.png", "An Nasiriyah Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "An Nasiriyah",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "An Nasiriyah Airbase Command Center",
					x = -00123388,
					y = 00086185,
				},
				[2] = {
					name = "An Nasiriyah Airbase Command Center-2",
					x = -00123415,
					y = 00085877,
				},
				[3] = {
					name = "An Nasiriyah Airbase Ammo Supply 1",
					x = -00123326,
					y = 00085778,
				},
				[4] = {
					name = "An Nasiriyah Airbase Ammo Supply 2",
					x = -00123456,
					y = 00085709,
				},
				[5] = {
					name = "An Nasiriyah Airbase Fuel Supply",
					x = -00123555,
					y = 00085836,
				},
			},
		},
		["An Nasiriyah Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 7,
            picture = {"An Nasiriyah Airbase.png", "An Nasiriyah Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "An Nasiriyah",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Abu al-Duhur Airbase"] = {
			inactive = true,
			task = "Strike",
			priority = 6,
			picture = {"Abu al-Duhur Airbase.png", "Abu al-Duhur Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Abu al-Duhur",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Abu al-Duhur Airbase Command Center 1",
					x = 00076702,
					y = 00112522,
				},
				[2] = {
					name = "Abu al-Duhur Airbase Command Center 2",
					x = 00076658,
					y = 00112560,
				},
				[3] = {
					name = "Abu al-Duhur Airbase Command Center 3",
					x = 00076645,
					y = 00112546,
				},
				[4] = {
					name = "Abu al-Duhur Airbase Command Center 4",
					x = 00076624,
					y = 00112431,
				},
				[5] = {
					name = "Abu al-Duhur Airbase Ammo Supply 1",
					x = 00076853,
					y = 00112358,
				},
				[6] = {
					name = "Abu al-Duhur Airbase Ammo Supply 2",
					x = 00076856,
					y = 00109867,
				},
				[7] = {
					name = "Abu al-Duhur Airbase Fuel Tank 1",
					x = 00076828,
					y = 00112241,
				},
				[8] = {
					name = "Abu al-Duhur Airbase Fuel Tank 2",
					x = 00076785,
					y = 00112236,
				},
				[9] = {
					name = "Abu al-Duhur Airbase Fuel Tank 3",
					x = 00076754,
					y = 00111936,
				},
				[10] = {
					name = "Abu al-Duhur Airbase Fuel Tank 4",
					x = 00076753,
					y = 00111916,
				},
				[11] = {
					name = "Abu al-Duhur Airbase Fuel Tank 5",
					x = 00076750,
					y = 00111895,
				},
				[12] = {
					name = "Abu al-Duhur Airbase Fuel Tank 6",
					x = 00076745,
					y = 00111876,
				},
				[13] = {
					name = "Abu al-Duhur Airbase Fuel Tank 7",
					x = 00076741,
					y = 00111858,
				},
				[14] = {
					name = "Abu al-Duhur Airbase Fuel Tank 8",
					x = 00076738,
					y = 00111842,
				},
				[15] = {
					name = "Abu al-Duhur Airbase Fuel Tank 9",
					x = 00076721,
					y = 00111307,
				},
				[16] = {
					name = "Abu al-Duhur Airbase Fuel Tank 10",
					x = 00076720,
					y = 00111350,
				},
				[17] = {
					name = "Abu al-Duhur Airbase Fuel Tank 11",
					x = 00076633,
					y = 00112359,
				},
				[18] = {
					name = "Abu al-Duhur Airbase Fuel Tank 12",
					x = 00076633,
					y = 00112377,
				},
			},
		},
		["Abu al-Duhur Airbase Runway"] = {
            inactive = true,
			task = "Runway Attack",
            priority = 7,
            picture = {"Abu al-Duhur Airbase.png", "Abu al-Duhur Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Abu al-Duhur",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Damascus Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 8,
			picture = {"Damascus Airbase.png", "Damascus Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "Damascus",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Damascus Airbase Control Tower",
					x = -180308.640625,
					y = 51654.91796875,
				},
				[2] = {
					name = "Damascus Airbase Command Center",
					x = -180019.5625,
					y = 51391.85546875,
				},
				[3] = {
					name = "Damascus Airbase Ammo Supply 1",
					x = -179822.234375,
					y = 51280.5390625,
				},
				[4] = {
					name = "Damascus Airbase Ammo Supply 2",
					x = -179892.9375,
					y = 51263.921875,
				},
				[5] = {
					name = "Damascus Airbase Fuel Tank 1",
					x = -179928.375,
					y = 51153.49609375,
				},
				[6] = {
					name = "Damascus Airbase Fuel Tank 2",
					x = -179939.453125,
					y = 51140.43359375,
				},
				[7] = {
					name = "Damascus Airbase Fuel Tank 3",
					x = -179942.375,
					y = 51166.3359375,
				},
				[8] = {
					name = "Damascus Airbase Fuel Tank 4",
					x = -179953,
					y = 51152.6328125,
				},
				[9] = {
					name = "Damascus Airbase Fuel Tank 5",
					x = -179952.140625,
					y = 51125.17578125,
				},
				[10] = {
					name = "Damascus Airbase Fuel Tank 6",
					x = -179965.75,
					y = 51110.9765625,
				},
				[11] = {
					name = "Damascus Airbase Fuel Tank 7",
					x = -179989.0625,
					y = 51141.203125,
				},
				[12] = {
					name = "Damascus Airbase Fuel Tank 8",
					x = -179997.8125,
					y = 51190.9609375,
				},
			},
		},
		["Damascus Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 9,
            picture = {"Damascus Airbase.png", "Damascus Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "Damascus",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Al-Dumayr Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 8,
			picture = {"Al-Dumayr Airbase.png", "Al-Dumayr Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "Al-Dumayr",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Al-Dumayr Airbase Command Center-1",
					x = -00158137,
					y = 00073882,
				},
				[2] = {
					name = "Al-Dumayr Airbase Command Center-2",
					x = -00158171,
					y = 00073900,
				},
				[3] = {
					name = "Al-Dumayr Airbase Command Center-3",
					x = -00158284,
					y = 00073855,
				},
				[4] = {
					name = "Al-Dumayr Airbase Command Center-4",
					x = -00158301,
					y = 00073821,
				},
				[5] = {
					name = "Al-Dumayr Airbase Ammo Supply 1",
					x = -00157783,
					y = 00073655,
				},
				[6] = {
					name = "Al-Dumayr Airbase Ammo Supply 2",
					x = -00158093,
					y = 00073962,
				},
				[7] = {
					name = "Al-Dumayr Airbase Ammo Supply 3",
					x = -00158165,
					y = 00073635,
				},
				[8] = {
					name = "Al-Dumayr Airbase Ammo Supply 4",
					x = -00158352,
					y = 00073836,
				},
				[9] = {
					name = "Al-Dumayr Airbase Fuel Tank 1",
					x = -00157858,
					y = 00073925,
				},
				[10] = {
					name = "Al-Dumayr Airbase Fuel Tank 2",
					x = -00157865,
					y = 00073909,
				},
				[11] = {
					name = "Al-Dumayr Airbase Fuel Tank 3",
					x = -00157872,
					y = 00073895,
				},
				[12] = {
					name = "Al-Dumayr Airbase Fuel Tank 4",
					x = -00157936,
					y = 00074464,
				},
				[13] = {
					name = "Al-Dumayr Airbase Fuel Tank 5",
					x = -00157936,
					y = 00074475,
				},
				[14] = {
					name = "Al-Dumayr Airbase Fuel Tank 6",
					x = -00157935,
					y = 00074486,
				},
			},
		},
		["Al-Dumayr Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 9,
            picture = {"Al-Dumayr Airbase.png", "Al-Dumayr Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "Al-Dumayr",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Bassel Al-Assad Airbase"] = {
			inactive = true,
			task = "Strike",
			priority = 7,
			picture = {"Bassel Al-Assad Airbase-North.png", "Bassel Al-Assad Airbase-South.png", "Bassel Al-Assad Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Bassel Al-Assad",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Bassel Al-Assad Airbase Control Tower",
					x = 00042539,
					y = 00005322,
				},
				[2] = {
					name = "Bassel Al-Assad Airbase Command Center-1",
					x = 00042513,
					y = 00005300,
				},
				[3] = {
					name = "Bassel Al-Assad Airbase Command Center-2",
					x = 00042523,
					y = 00005254,
				},
				[4] = {
					name = "Bassel Al-Assad Airbase Command Center-3",
					x = 00042515,
					y = 00005319,
				},
				[5] = {
					name = "Bassel Al-Assad Airbase Command Center-4",
					x = 00042494,
					y = 00005254,
				},
				[6] = {
					name = "Bassel Al-Assad Airbase Ammo Supply-1",
					x = 00043435,
					y = 00006538,
				},
				[7] = {
					name = "Bassel Al-Assad Airbase Ammo Supply-2",
					x = 00043114,
					y = 00005180,
				},
				[8] = {
					name = "Bassel Al-Assad Airbase Ammo Supply-3",
					x = 00040856,
					y = 00006037,
				},
				[9] = {
					name = "Bassel Al-Assad Airbase Ammo Supply-4",
					x = 00040513,
					y = 00005512,
				},
				[10] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 1",
					x = 00042977,
					y = 00006020,
				},
				[11] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 2",
					x = 00042975,
					y = 00006002,
				},
				[12] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 3",
					x = 00042961,
					y = 00006020,
				},
				[13] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 4",
					x = 00042958,
					y = 00006002,
				},
				[14] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 5",
					x = 00042942,
					y = 00006021,
				},
				[15] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 6",
					x = 00042941,
					y = 00006002,
				},
				[16] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 7",
					x = 00042925,
					y = 00006003,
				},
				[17] = {
					name = "Bassel Al-Assad Airbase Fuel Tank 8",
					x = 00042924,
					y = 00006021,
				},
			},
		},
		["Bassel Al-Assad Airbase Runway"] = {
            inactive = true,
			task = "Runway Attack",
            priority = 8,
            picture = {"Bassel Al-Assad Airbase-North.png", "Bassel Al-Assad Airbase-South.png", "Bassel Al-Assad Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Bassel Al-Assad",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Shayrat Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 7,
			picture = {"Shayrat Airbase.png", "Shayrat Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Shayrat",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Shayrat Airbase Command Center",
					x = -61278.79296875,
					y = 91892.609375,
				},
				[2] = {
					name = "Shayrat Airbase Command Center-2",
					x = -61364.0078125,
					y = 92012.96875,
				},
				[3] = {
					name = "Shayrat Airbase Ammo Supply 1",
					x = -60793.76171875,
					y = 91626.046875,
				},
				[4] = {
					name = "Shayrat Airbase Ammo Supply 2",
					x = -60854.96875,
					y = 91893.9765625,
				},
				[5] = {
					name = "Shayrat Airbase Fuel Tank 1",
					x = -61680.81640625,
					y = 92954.859375,
				},
				[6] = {
					name = "Shayrat Airbase Fuel Tank 2",
					x = -61692.44921875,
					y = 92972.9921875,
				},
				[7] = {
					name = "Shayrat Airbase Fuel Tank 3",
					x = -61704.015625,
					y = 92990.7421875,
				},
			},
		},
		["Shayrat Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 8,
            picture = {"Shayrat Airbase.png", "Shayrat Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Shayrat",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Wujah Al Hajar Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 6,
			picture = {"Wujah Al Hajar Airbase.png", "Wujah Al Hajar Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Wujah Al Hajar",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Wujah Al Hajar Airbase Command Center",
					x = -81340.546875,
					y = -22911.958984375,
				},
				[2] = {
					name = "Wujah Al Hajar Airbase Ammo Supply 1",
					x = -81012.2265625,
					y = -22843.208984375,
				},
				[3] = {
					name = "Wujah Al Hajar Airbase Ammo Supply 2",
					x = -81063.6875,
					y = -23029.099609375,
				},
				[4] = {
					name = "Wujah Al Hajar Airbase Fuel Tank 1",
					x = -81315.2421875,
					y = -22981.892578125,
				},
				[5] = {
					name = "Wujah Al Hajar Airbase Fuel Tank 2",
					x = -81330.6015625,
					y = -22967.443359375,
				},
			},
		},
		["Wujah Al Hajar Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 5,
            picture = {"Wujah Al Hajar Airbase.png", "Wujah Al Hajar Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Wujah Al Hajar",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Qabr as Sitt Airbase"] = {
			inactive = true,
			task = "Strike",
			priority = 8,
			picture = {"Qabr as Sitt Airbase.png", "Qabr as Sitt Airbase-Sat.png", "Syria-South.png"},
			attributes = {"Structure"},
			db_airbaseName = "Qabr as Sitt",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Qabr as Sitt Airbase Command Center",
					x = -00174433,
					y = 00036833,
				},
				[2] = {
					name = "Qabr as Sitt Airbase Command Center-2",
					x = -00174399,
					y = 00036804,
				},
				[3] = {
					name = "Qabr as Sitt Airbase Ammo Supply 1",
					x = -00174475,
					y = 00037338,
				},
				[4] = {
					name = "Qabr as Sitt Airbase Ammo Supply 2",
					x = -00174590,
					y = 00036866,
				},
				[5] = {
					name = "Qabr as Sitt Airbase Ammo Supply 3",
					x = -00174688,
					y = 00037463,
				},
				[6] = {
					name = "Qabr as Sitt Airbase Fuel Tank 1",
					x = -00174678,
					y = 00036835,
				},
				[7] = {
					name = "Qabr as Sitt Airbase Fuel Tank 2",
					x = -00174692,
					y = 00036839,
				},
			},
		},
		["Qabr as Sitt Airbase Runway"] = {
            inactive = true,
			task = "Runway Attack",
            priority = 9,
            picture = {"Qabr as Sitt Airbase.png", "Qabr as Sitt Airbase-Sat.png", "Syria-South.png"},
            attributes = {"Runway"},
            db_airbaseName = "Qabr as Sitt",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Rene Mouawad Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 4,
			picture = {"Rene Mouawad Airbase.png", "Rene Mouawad Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Rene Mouawad",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Rene Mouawad Airbase Command Center",
					x = -00047832,
					y = 00008800,
				},
				[2] = {
					name = "Rene Mouawad Airbase Command Center-2",
					x = -00047884,
					y = 00008682,
				},
				[3] = {
					name = "Rene Mouawad Airbase Ammo Supply 1",
					x = -00047794,
					y = 00008652,
				},
				[4] = {
					name = "Rene Mouawad Airbase Ammo Supply 2",
					x = -00047965,
					y = 00008437,
				},
				[5] = {
					name = "Rene Mouawad Airbase Fuel Tank 1",
					x = -00047618,
					y = 00009091,
				},
				[6] = {
					name = "Rene Mouawad Airbase Fuel Tank 2",
					x = -00047636,
					y = 00009057,
				},
			},
		},
		["Rene Mouawad Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 5,
            picture = {"Rene Mouawad Airbase.png", "Rene Mouawad Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Rene Mouawad",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Tiyas Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 8,
			picture = {"Tiyas Airbase.png", "Tiyas Airbase-Sat.png", "Syria-North.png"},
			attributes = {"Structure"},
			db_airbaseName = "Tiyas",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Tiyas Airbase Command Center",
					x = -00058207,
					y = 00156725,
				},
				[2] = {
					name = "Tiyas Airbase Ammo Supply 1",
					x = -00057995,
					y = 00156582,
				},
				[3] = {
					name = "Tiyas Airbase Ammo Supply 2",
					x = -00058119,
					y = 00156741,
				},
				[4] = {
					name = "Tiyas Airbase Fuel Tank 1",
					x = -00057795,
					y =  00156892,
				},
				[5] = {
					name = "Tiyas Airbase Fuel Tank 2",
					x = -00057796,
					y = 00156909,
				},
				
				[6] = {
					name = "Tiyas Airbase Fuel Tank 3",
					x = -00057794,
					y = 00156928,
				},
				
				[7] = {
					name = "Tiyas Airbase Fuel Tank 4",
					x = -00057794,
					y = 00156946,
				},
			},
		},
		["Tiyas Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 9,
            picture = {"Tiyas Airbase.png", "Tiyas Airbase-Sat.png", "Syria-North.png"},
            attributes = {"Runway"},
            db_airbaseName = "Tiyas",
            firepower = {
                min = 4,
                max = 8,
            },
        },	
	},
	["red"] = {
		["Taftanaz SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Taftanaz",
			radius = 50000,
			inactive = false,
		},
		["Rene Mouawad SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Rene Mouawad",
			radius = 50000,
			inactive = false,
		},
		["Tha\'lah SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Tha\'lah",
			radius = 50000,
			inactive = false,
		},
		["Beirut-Rafic Hariri Airbase"] = {
			task = "Strike",
			inactive = true,
			priority = 10,
			picture = {"Beirut-Rafic Hariri Airbase.png"},
			attributes = {"Structure"},
			db_airbaseName = "Beirut-Rafic Hariri",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Beirut-Rafic Hariri Airbase Control Tower",
					x = -131012.328125,
					y = -41872.32421875,
				},
				[2] = {
					name = "Beirut-Rafic Hariri Airbase Control Tower-2",
					x = -131527.828125,
					y = -41776.6171875,
				},
				[3] = {
					name = "Beirut-Rafic Hariri Airbase Ammo Supply 1",
					x = -130634.0078125,
					y = -41810.015625,
				},
				[4] = {
					name = "Beirut-Rafic Hariri Airbase Ammo Supply 2",
					x = -130657.8125,
					y = -41782.8359375,
				},
				[5] = {
					name = "Beirut-Rafic Hariri Airbase Ammo Supply 3",
					x = -130875.6953125,
					y = -41229.08984375,
				},
				[6] = {
					name = "Beirut-Rafic Hariri Airbase Ammo Supply 4",
					x = -130899.953125,
					y = -41196.8203125,
				},
				[7] = {
					name = "Beirut-Rafic Hariri Airbase Ammo Supply 5",
					x = -130976.953125,
					y = -41804.71875,
				},
				[8] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 1",
					x = -132030.3125,
					y = -40703.15234375,
				},
				[9] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 2",
					x = -132031.890625,
					y = -40753.98828125,
				},
				[10] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 3",
					x = -132031.890625,
					y = -40753.98828125,
				},
				[11] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 4",
					x = -132030.3125,
					y = -40703.15234375,
				},
				[12] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 5",
					x = -132103.0625,
					y = -40852.19921875,
				},
				[13] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 6",
					x = -132101.546875,
					y = -40875.5859375,
				},
				[14] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 7",
					x = -132101.671875,
					y = -40899,
				},
				[15] = {
					name = "Beirut-Rafic Hariri Airbase Fuel Tank 8",
					x = -132101.515625,
					y = -40920.41796875,
				},
			},
		},
		["Beirut-Rafic Hariri Airbase Runway"] = {
            inactive = true,
			task = "Runway Attack",
            priority = 10,
            picture = {"Beirut-Rafic Hariri Airbase.png"},
            attributes = {"Runway"},
            db_airbaseName = "Beirut-Rafic Hariri",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["EWR-Larnaca Site"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "EWR-Larnaca",
		},
		["EWR-Incirlik Site"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "EWR-Incirlik",
		},
		["EWR-Cyprus Site"] = {
			task = "Strike",
			priority = 10,
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "EWR-Cyprus",
		},
		["Abu al-Duhur Airbase Alert 140 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Abu al-Duhur",
			radius = 140000,
			inactive = true,
		},
		["CAP North Syria"] = {
			task = "CAP",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP North Syria",
			axis = 45, --in degrees
			radius = 50000, 
			text = "Syrian north frontier",
			inactive = true,
		},
		["CAP Center Syria"] = {
            task = "CAP",
            priority = 20,
            attributes = {""},
            firepower = {
                min = 2,
                max = 4,
            },
            refpoint = "CAP Center Syria",
            axis = 225, --in degrees
            radius = 50000, 
            text = "Syrian Center area",
            inactive = true,
        },
		["CAP Libanon Syria"] = {
			task = "CAP",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Libanon Syria",
			axis = 280, --in degrees
			radius = 50000, 
			text = "over Libanon area",
			inactive = false,
		},
		["CAP Libanon Syria-Bis"] = {
			task = "CAP",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Libanon Syria-Bis",
			axis = 280, --in degrees
			radius = 50000, 
			text = "after Patriot activation",
			inactive = false,
		},
		["CAP South Syria"] = {
			task = "CAP",
			priority = 20,
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP South Syria",
			axis = 125, --in degrees
			radius = 50000, 
			text = "South syrian frontier area",
			inactive = false,
		},
		["Sweep South"] = {
			task = "Fighter Sweep",
			priority = 6,
			attributes = {},
			firepower = {
				min = 4,
				max = 6,
			},
			x = -246773,
			y = 864192,
			text = "in the south area",
			inactive = false,
		},		
		["Bassel Al-Assad Airbase Alert 80 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Bassel Al-Assad",
			radius = 80000,
			inactive = true,
		},
		["An Nasiriyah Airbase Alert 250 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "An Nasiriyah",
			radius = 250000,
			inactive = false,
		},
		["Tiyas Airbase Alert 300 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Tiyas",
			radius = 300000,
			inactive = false,
		},
		["Shayrat Airbase Alert 230 Km"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Shayrat Airbase",
			radius = 230000,
			inactive = false,
		},
		["Aleppo Airbase Alert 90 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Aleppo",
			radius = 90000,
			inactive = true,
		},
		["Al-Dumayr Airbase Alert 220 Km"] = {
			task = "Intercept",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "Al-Dumayr",
			radius = 220000,
			inactive = true,
		},
		["TF-71"] = {
			task = "Anti-ship Strike",
			priority = 6,
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "ship",
			name = "TF-71",
		},				
		["LHA-Tarawa-Group"] = {
			task = "Anti-ship Strike",
			priority = 8,
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "ship",
			name = "LHA-Tarawa-Group",
		},
		-- ["LHA-Nassau-Group"] = {
			-- task = "Anti-ship Strike",
			-- priority = 6,
			-- attributes = {"ship"},
			-- firepower = {
				-- min = 6,
				-- max = 12,
			-- },
			-- class = "ship",
			-- name = "LHA-Nassau-Group",
		-- },
		-- ["NATO Convoy 1"] = {
			-- task = "Anti-ship Strike",
			-- priority = 5,
			-- attributes = {"ship"},
			-- firepower = {
				-- min = 6,
				-- max = 12,
			-- },
			-- class = "ship",
			-- name = "NATO Convoy 1",
		-- },
		["Patriot in Beirut"] = {
			task = "Strike",
			priority = 20,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Patriot in Beirut",
			inactive = true,
		},
		["Larnaca Airbase Patriot Site"] = {
			task = "Strike",
			priority = 8,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Larnaca Airbase Patriot Site",
		},
		["Incirlik Airbase Patriot Site"] = {
			task = "Strike",
			priority = 8,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Incirlik Airbase Patriot Site",
		},
		["Akrotiri Airbase Hawk Site"] = {
			task = "Strike",
			priority = 8,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Akrotiri Airbase Hawk Site",
		},
		["Paphos Airbase Hawk Site"] = {
			task = "Strike",
			priority = 8,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Paphos Airbase Hawk Site",
		},
		["Libanese-5th-Inf-Brigade-HQ"] = {
			task = "Strike",
			priority = 16,
			additionalGroupName = {"Libanese-5th-Inf-Brigade-HQ-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-5th-Inf-Brigade-HQ-1",
				},
				[2] = {
					name = "Libanese-5th-Inf-Brigade-HQ-2",
				},
				[3] = {
					name = "Libanese-5th-Inf-Brigade-HQ-3",
				},
				[4] = {
					name = "Libanese-5th-Inf-Brigade-HQ-4",
				},
				[5] = {
					name = "Libanese-5th-Inf-Brigade-HQ-5",
				},
				[6] = {
					name = "Libanese-5th-Inf-Brigade-HQ-6",
				},
			},
		},
		["Libanese-5th-Inf-Brigade-Cie-1"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-5th-Inf-Brigade-Cie-1-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-1",
				},
				[2] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-2",
				},
				[3] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-3",
				},
				[4] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-4",
				},
				[5] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-5",
				},
				[6] = {
					name = "Libanese-5th-Inf-Brigade-Cie-1-6",
				},
			},
		},
		["Libanese-5th-Inf-Brigade-Cie-2"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-5th-Inf-Brigade-Cie-2-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-1",
				},
				[2] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-2",
				},
				[3] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-3",
				},
				[4] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-4",
				},
				[5] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-5",
				},
				[6] = {
					name = "Libanese-5th-Inf-Brigade-Cie-2-6",
				},
			},
		},
		["Libanese-5th-Inf-Brigade-Cie-3"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-5th-Inf-Brigade-Cie-3-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-1",
				},
				[2] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-2",
				},
				[3] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-3",
				},
				[4] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-4",
				},
				[5] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-5",
				},
				[6] = {
					name = "Libanese-5th-Inf-Brigade-Cie-3-6",
				},
			},
		},
		["Libanese-6th-Inf-Brigade-HQ"] = {
			task = "Strike",
			priority = 16,
			additionalGroupName = {"Libanese-6th-Inf-Brigade-HQ-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-6th-Inf-Brigade-HQ-1",
				},
				[2] = {
					name = "Libanese-6th-Inf-Brigade-HQ-2",
				},
				[3] = {
					name = "Libanese-6th-Inf-Brigade-HQ-3",
				},
				[4] = {
					name = "Libanese-6th-Inf-Brigade-HQ-4",
				},
				[5] = {
					name = "Libanese-6th-Inf-Brigade-HQ-5",
				},
				[6] = {
					name = "Libanese-6th-Inf-Brigade-HQ-6",
				},
			},
		},	
		["Libanese-6th-Inf-Brigade-Cie-1"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-6th-Inf-Brigade-Cie-1-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-1",
				},
				[2] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-2",
				},
				[3] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-3",
				},
				[4] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-4",
				},
				[5] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-5",
				},
				[6] = {
					name = "Libanese-6th-Inf-Brigade-Cie-1-6",
				},
			},
		},
		["Libanese-6th-Inf-Brigade-Cie-2"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-6th-Inf-Brigade-Cie-2-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-1",
				},
				[2] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-2",
				},
				[3] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-3",
				},
				[4] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-4",
				},
				[5] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-5",
				},
				[6] = {
					name = "Libanese-6th-Inf-Brigade-Cie-2-6",
				},
			},
		},
		["Libanese-6th-Inf-Brigade-Cie-3"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-6th-Inf-Brigade-Cie-3-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-1",
				},
				[2] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-2",
				},
				[3] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-3",
				},
				[4] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-4",
				},
				[5] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-5",
				},
				[6] = {
					name = "Libanese-6th-Inf-Brigade-Cie-3-6",
				},
			},
		},
		["Libanese-4th-Inf-Brigade-HQ"] = {
			task = "Strike",
			priority = 16,
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-4th-Inf-Brigade-HQ-1",
				},
				[2] = {
					name = "Libanese-4th-Inf-Brigade-HQ-2",
				},
				[3] = {
					name = "Libanese-4th-Inf-Brigade-HQ-3",
				},
				[4] = {
					name = "Libanese-4th-Inf-Brigade-HQ-4",
				},
				[5] = {
					name = "Libanese-4th-Inf-Brigade-HQ-5",
				},
				[6] = {
					name = "Libanese-4th-Inf-Brigade-HQ-6",
				},
			},
		},
		["Libanese-4th-Inf-Brigade-Cie-1"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-4th-Inf-Brigade-Cie-1-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-1",
				},
				[2] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-2",
				},
				[3] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-3",
				},
				[4] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-4",
				},
				[5] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-5",
				},
				[6] = {
					name = "Libanese-4th-Inf-Brigade-Cie-1-6",
				},
			},
		},
		["Libanese-4th-Inf-Brigade-Cie-2"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-4th-Inf-Brigade-Cie-2-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-1",
				},
				[2] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-2",
				},
				[3] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-3",
				},
				[4] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-4",
				},
				[5] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-5",
				},
				[6] = {
					name = "Libanese-4th-Inf-Brigade-Cie-2-6",
				},
			},
		},
		["Libanese-4th-Inf-Brigade-Cie-3"] = {
			task = "Strike",
			priority = 15,
			additionalGroupName = {"Libanese-4th-Inf-Brigade-Cie-3-AA"},
			--picture = {""},
			attributes = {""},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-1",
				},
				[2] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-2",
				},
				[3] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-3",
				},
				[4] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-4",
				},
				[5] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-5",
				},
				[6] = {
					name = "Libanese-4th-Inf-Brigade-Cie-3-6",
				},
			},
		},
	},
}